## Create (Set)

Creates a set.




### Description

The following statement allows for adding a set to a schema. It is very similar to the `WITH SET` statement:

<pre>
CREATE [SESSION] [ DYNAMIC | STATIC ] SET name AS MDX-expression
               , DESCRIPTION = string-expression
</pre>

`DYNAMIC SETs` are evaluated once per MDX query. The context of evaluation is the cube defined in the query.

Example :

<pre>
CREATE DYNAMIC SET [Top 3 Countries / Amount] as TopCount( [Geography].[Geo].[City].Members, 3, [Measures].[Amount] )")
</pre>

`STATIC SETs`, the default modifier, are evaluated only once. The context of evaluation, cube, needs to be defined in the statement. Therefore, `STATIC SETs` can be used for example to cache costly evaluations.

Example :

<pre>
CREATE STATIC SET [Sales].[Top 3 Countries / Amount] as TopCount( [Geography].[Geo].[City].Members, 3, [Measures].[Amount] )")
</pre>

As an alternate solution for defining the DESCRIPTION property,
use the [schema localization](../user_guide/schemas_cubes/localization.md)
to both define and localize the description.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### TopCount (STATIC SET)

</div>

<div class="ic3-mdx-example-body" style="display:none">

In this example, we're caching at schema level the top 3 cities for the [Measures].[Amount]. Note the usage of the cube name (i.e., [Sales]) in the CREATE statement.

**Query**

```
CREATE SET [Sales].[Top 3 Countries / Amount] as TopCount( [Geography].[Geo].[City].Members, 3, [Measures].[Amount] )
                
             
                
SELECT
    [Measures].[Amount] ON 0,
    [Top 3 Countries / Amount] ON 1
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;New York</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Geneva</td>
 <td>128</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
 <td>64</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    [Measures].[Amount] ON 0,
    TopCount( [Geography].[Geo].[City].Members, 3, [Measures].[Amount] ) ON 1
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DYNAMIC example

</div>

<div class="ic3-mdx-example-body" style="display:none">

DYNAMIC sets although defined at schema level are evaluated once per query the first time they're being used taking into account the current context of evaluation (e.g., slicer).

In this example, we're computing the top 3 cities of the EU economic region because of the slicer in the query.

**Query**

```
CREATE DYNAMIC SET [Top 3 Countries - Amount] as TopCount( [Geography].[Geo].[City].Members, 3, [Measures].[Amount] )
                
             
                
SELECT
    [Measures].[Amount] ON 0,
    [Top 3 Countries - Amount] ON 1
FROM
    [Sales]
WHERE
    [Geography].[Economy].[EU]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Paris</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Barcelona</td>
 <td>2</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
 <td>1</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    [Measures].[Amount] ON 0,
    TopCount( [Geography].[Geo].[City].Members, 3, [Measures].[Amount] ) ON 1
FROM
    [Sales]
WHERE
    [Geography].[Economy].[EU]
```


 
</div>

                                                                                                            

### See Also


[Drop (Set)](Drop%20(Set).md)

[Create (Function)](Create%20(Function).md)

[Create (Member)](Create%20(Member).md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
